// Magician.cpp : Handlers for magic words
//

#include "stdafx.h"

#include "AdvMain.h"
#include "AdvIO.h"
#include "AdvUtil.h"
#include "Magician.h"

void magician
  (AdvGlobalContext& gc)   // global context
//
//  Handles the following magic words:
//    xyzzy
//    melenkurion
//    noside
//    samoht
//    thurb
//    knerl
//    zorton
//    klaetu
//    snoeze
//    blerbi
//    phuggg
//    fee fie foe foo (fum) sequence
//    sesame
//    vamotu
//    utomav
//  and various "old" magic words.
//
{
  switch (gc.m_nArg1)
  {
    case utomav:
      sayMessage (gc, nothing);
      break;

    case vamotu:
      if (at (belowtrap))
         if ((!gc.m_invisible [trapdoor]) && (gc.m_nState [trapdoor] == 0))
            {
              sayMessage (gc, trapopens);
              gc.m_nState [trapdoor] = 1;
            }
         else
            sayMessage (gc, nothing);
      else
         sayMessage (gc, nothing);
      break;

    case oldmagic:
      sayMessage (gc, magickword);
      break;

    case fee:
    case fie:
    case foe:
    case foo:
      if (gc.m_nFooBar == (fee - gc.m_nArg1))
         {
           gc.m_nFooBar++;
           if (gc.m_nFooBar < 4)
              sayMessage (gc, ok);
           else
              {
                gc.m_nFooBar = 0;

                // No effect if eggs are already in giant room or have been thrown in the chasm
                if ((gc.m_nWhereIs [eggs] == giant) || (gc.m_nWhereIs [eggs] == ylem))
                   sayMessage (gc, nothing);
                else
                   {
                     // Tell him about it
                     if (near (eggs))
                        gc.m_nState [eggs] = 1;     // "The nest of golden eggs has vanished!"
                     else
                        if (at (giant))
                           gc.m_nState [eggs] = 0;  // "There is a nest of golden eggs here!"
                        else
                           gc.m_nState [eggs] = 2;  // "Done!"
                     describeObject (gc, eggs, gc.m_nState [eggs]);

                     // Troll doesn't like it if you do this more than once!
                     if (gc.m_nWhereIs [eggs] == limbo)       // if eggs were given as toll
                        {
                          gc.m_special1 [troll] = true;       // can't be fooled twice
                          if ((gc.m_nState [troll] == 1) ||	  // bought off, not crossed
                              (gc.m_nState [troll] == 2))     // bought off, crossed
	                           {
                               // And if you do it at the chasm, the troll comes back
                               if (near (troll2))               // at the chasm with a good bridge
                                  {
                                    sayMessage (gc, blank);
                                    gc.m_nState [troll] = 5;                          // "The burly troll, muttering under his breath, steps out
                                    describeObject (gc, troll, gc.m_nState [troll]);	// from beneath the bridge.  He looks positively furious!"
                                    gc.m_nState [troll] = 0;		                      // normal troll mode
                                    apport (troll2, limbo);                           // discard fake troll
                                  }

                               // Bring the troll back to the correct location.  If special2[troll] is set, the
                               // adventurer is currently in the "neofchasm" side of the world; otherwise he's in
                               // the "swofchasm" side.
                               if (at (swofchasm) || !gc.m_special2 [troll])
                                  apport (troll, swofchasm);
                               else
                                  apport (troll, neofchasm);
	                           }
                        }

	                   apport (eggs, giant);
	                   gc.m_nState [eggs] = 0;
	                   gc.m_nState [troll] = 0;
                   }
              }
         }
      else
         {
           sayMessage (gc, start_over);
           gc.m_nFooBar = 0;
         }
      break;

    case fum:
      sayMessage (gc, start_over);
      gc.m_nFooBar = 0;
      break;

    case xyzzy:
      if ((gc.m_nCmdWords ==1) && (at(building) || at(debris)))
         if ((gc.m_nClosure < 2) && !gc.m_bNoMagic)
            {
              gc.m_bSaidXyzzyPlugh = true;
              gc.m_nPrevLoc = gc.m_nHere;
              gc.m_nHere = (gc.m_nHere == building ? debris : building);
              gc.m_bMoved = true;
              break;
            }
         else
            gc.m_bPanicked = true;
         gc.m_bOk2Describe = false;
         sayMessage (gc, nothing);
      break;

    case plugh:
      if ((gc.m_nCmdWords ==1) && (at(building) || at(y2) || at(fake_y2) || at(platform)))
         if ((gc.m_nClosure < 2) && !gc.m_bNoMagic)
            {
              gc.m_bSaidXyzzyPlugh = true;
              gc.m_nPrevLoc = gc.m_nHere;
              switch (gc.m_nHere)
              {
                case building: gc.m_nHere = y2; break;
                case y2:       gc.m_nHere = building; break;
                case fake_y2:  gc.m_nHere = platform; break;
                case platform: gc.m_nHere = fake_y2; break;
              }
              gc.m_bMoved = true;
              break;
            }
         else
            gc.m_bPanicked = true;
         gc.m_bOk2Describe = false;
         sayMessage (gc, nothing);
      break;

    case melenkurion:
      gc.m_bOk2Describe = false;
      if (near (statue) && (gc.m_nState [statue] == 0))
         {
           gc.m_nState [statue] = 1;
           gc.m_noDesc [statue] = false;
           sayMessage (gc, crumble);
         }
      else
         sayMessage (gc, nothing);
      break;

    case noside:
      gc.m_bOk2Describe = false;
      if (gc.m_nArg2 != samoht)
         sayMessage (gc, nothing);
      else
         if (gc.m_special1 [lamp] || gc.m_lit [gc.m_nHere] || !gc.m_visited [lair] || !near(lamp))
            sayMessage (gc, nothing);
         else
            if (carrying (lamp))
               {
                 gc.m_bOk2Describe = true;
                 sayMessage (gc, fzap);
                 coroner (gc);
               }
            else
               if (gc.m_nLampLife > 40)
                  {
                    apport (lamp, ylem);
                    gc.m_nState [batteries] = 1;    // so lamp doesn't come back
                    gc.m_nState [lamp] = 0;
                    gc.m_nLampLife = 0;

                    if (chance (50))
                       {
                         sayMessage (gc, lamp_goes_poof);
                         sayMessage (gc, itisnowdark);    // do we need this?
                       }
                    else
                       {
                         sayMessage (gc, lamp_explodes);
                         coroner (gc);
                       }
                  }
               else
                  {
                    sayMessage (gc, lamp_recharged);
                    gc.m_nLampLife += 150;
                    gc.m_nState [lamp] = 1;
                    gc.m_special1 [lamp] = true;
                    gc.m_bMoved = true;
                    gc.m_bOk2Describe = true;
                  }
      break;

    case thurb:
      if (at (icecave_36))
         {
           gc.m_nHere = ice;
           gc.m_nPrevLoc = gc.m_nHere;    // BACK shouldn't work
           gc.m_bMoved = true;
         }
      else
         {
           sayMessage (gc, nothing);
           gc.m_bOk2Describe = false;
         }
      break;

    case samoht:
      sayMessage (gc, nothing);
      gc.m_bOk2Describe = false;
      break;

    case knerl:
    case zorton:
    case klaetu:
    case snoeze:
    case blerbi:
      gc.m_bOk2Describe = false;
      if (near (safe))
         if (gc.m_nState [safe] == 0)
            if ((gc.m_nCmdWords == 1) && (gc.m_nArg1 == gc.m_nPassword))
               {
                 sayMessage (gc, safe_opens);
                 gc.m_nState [safe] = 1;
                 gc.m_special1 [safe] = true;
               }
            else
               if (!gc.m_special1 [safe])
                  {
                    sayMessage (gc, safe_fuses);
                    sayMessage (gc, blank);
                    gc.m_nState [safe] = 2;     // melt the safe's door shut
                    gc.m_nState [blob] = 1;     // wake up the blob
                    gc.m_bTicker = true;        // blob is chasing us - quickly!
                    gc.m_bNoMagic = true;       // inhibit PLUGH, etc.
                    gc.m_nState [grate] = 0;    // lock him in cave
                  }
               else
                  sayMessage (gc, nothing);
         else
            sayMessage (gc, nothing);
      else
         sayMessage (gc, nothing);
      break;

    case phuggg:                                    // useful when being bothered by dwarves
      if (near (water))
         {
           gc.m_nWaterPhugg++;
           if (gc.m_nWaterPhugg == 1)		            // but don't use it near water! */
              {
                sayMessage (gc, jellyfish);
                coroner (gc);
                return;
              }
           else
              {
                sayMessage (gc, cave_destroyed);    // and certainly not *twice* near water!
                finis (gc);
              }
         }
      else
         if (near (dwarf))
            if (near(diamonds) || near(sword) || near(shards) || near(axe) || chance(20))
               {
                 if (gc.m_nDwarvesInRoom == 1)
                    sayMessage (gc, (it_didnt_work_1 + 2*random(3)));    // and not near sharp objects either!
                 else
                    sayMessage (gc, it_didnt_work_2 + 2*random(3));
                 coroner (gc);
                 return;
               }
            else
               {
                 // Otherwise works 80% of the time
                 apport (dwarf, limbo);
                 gc.m_nDwarfCount--;
                 if (gc.m_nDwarvesInRoom == 1)
	                  sayMessage (gc, it_worked_1 + 2*random(3));
                 else
                    sayMessage (gc, it_worked_2 + 2*random(3));
                 gc.m_nDwarvesInRoom = 0;
                 gc.m_bOk2Describe = false;
               }
         else
            sayMessage (gc, nothing);
      break;

    case sesame:
      sayMessage (gc, magickword);
      break;

    default:
      printf ("<GLITCH!> Magic words not handled for arg1=%d, arg2=%d, context=%d\n",
              gc.m_nArg1, gc.m_nArg2, gc.m_nContext);
      printf ("Please report this bug to ravib@ravib.com.  Thanks!\n");
      break;
  }
}

void magician2
  (AdvGlobalContext& gc)   // global context
//
//  Handles exiting from the small, cylinderical chamber (end game).
//
{
#define respond( progress )   if (gc.m_nEscape == progress)   \
                                 {                            \
                                   gc.m_nEscape++;            \
                                   sayMessage (gc, ok);       \
                                   break;                     \
                                 }                            \
                              else                            \
                                 {                            \
                                   gc.m_nEscape = 0;          \
                                   sayMessage (gc, nothing);  \
                                   break;                     \
                                 }

  // Keep track of his escape state
  switch (gc.m_nArg1)
  {
    case blerbi:
      respond (15);
    case fee:
      respond (14);
    case fie:
      respond (13);
    case foe:
      respond (12);
    case foo:
      respond (11);
    case klaetu:
      respond (10);
    case knerl:
      respond (9);
    case melenkurion:
      respond (8);
    case noside:
      respond (7);
    case phuggg:
      respond (6);
    case plugh:
      respond (5);
    case samoht:
      respond (4);
    // case sesame:
    //   respond (4);   // Not in CP/M version
    case snoeze:
      respond (3);
    case thurb:
      respond (2);
    case xyzzy:
      respond (1);
    case zorton:
      respond (0);
    default:
      sayMessage (gc, nothing);
      gc.m_nEscape = 0;
      break;
  }

  if (gc.m_nEscape == 16)
     {
       gc.m_nClosure = 4;
       gc.m_bMoved = true;
       gc.m_nHere = road;
       gc.m_nPrevLoc = road;
     }

#undef respond
}
