#ifndef ADV_COMMON_H
#define ADV_COMMON_H

#include <time.h>
#include "adventur.h"
      
struct game_data {
      // abbcom.h - something to do with locations???
       
      int abb[LOCSIZ+1];
      
      // placom.h - info on locations, or relating objects to their locations
      
      int atloc[LOCSIZ+1];
      int link[2*OBJSIZ+1];
      int place[OBJSIZ+1];
      int fixed[OBJSIZ+1];
      int key[LOCSIZ+1];
      int cond[LOCSIZ+1]; 
      int plac[OBJSIZ+1];
      int fixd[OBJSIZ+1];
      int prop[OBJSIZ+1];
      int holdng;
      
      // txtcom.h - texts for messages
      //   has absorbed mtxcom.h - links to "mtext" messages,
      //                ptxcom.h - links to ptext messages,
      //                and the other *text data
      
      // globals for storage allocation
      char *bblock,                 // beginning of string storage
           *nblock,                 // next available location in string storage
           *eblock;                 // last byte of string storage (bblock + length - 1)
      
      // Database section 1
      char *ltext[LOCSIZ+1];         // 150 LOCATIONS (LTEXT - long description)
      
      // Database section 2
      char *stext[LOCSIZ+1];         // 150 LOCATIONS (STEXT - short description)
      
      // Database section 3
      int travel[TRVSIZ+1];          // 750 travel options (originally had next 2 in it)
      int travwd[TRVSIZ+1];          //       travel keyword - split out from travel
      BOOL travlast[TRVSIZ+1];       //       TRUE is last travel for this loc
      
      // Database section 5
      char *ptext[OBJSIZ+1];         // 100 OBJECTS (PTEXT).
      char *ptexta[OBJSIZ+1][OBJALTMAX];  //  alt object descriptors
      
      // Database section 6
      char *rtext[RTXSIZ+1];         // 205 RANDOM MESSAGES (RTEXT).
      
      // Database section 8
      int actspk[VRBSIZ+1];          // 35 "action" verbs (defaults, points to section 6)
      
      // Database section 10
      char *ctext[CLSMAX+1];         // 12 DIFFERENT PLAYER CLASSIFICATIONS (CTEXT).
      
      // Database section 11
      int hints[HNTSIZ+1][5];         // 20 HINTS (HINTS), use indices 1 to 4.
      int hintlc[HNTSIZ+1];
      BOOL hinted[HNTSIZ+1];
      
      // Database section 12
      char *mtext[MAGSIZ+1];         // 35 MAGIC MESSAGES (MTEXT).
      
      // voccom.h - data regarding vocabulary
      
      int ktab[TABSIZ+1];
      int cntab[TABSIZ+1];           // new - in lieu of adding 1000*this to ktab
      char atab[TABSIZ+1][6];        // room for 5 chars + null terminator
      
      // globcom.h - put all the loose globals, not in some other specific common,
      //               in here
      int described_loc;                // last loc described by "describe_loc"
      int loc, oldloc, oldlc2, newloc;  // current and other locations of adventurer
      time_t saved;                     // these three were in wizcom (magic stuff) 
      // long savet;                    //   but they need to be in the data that
      int setup;                        //   gets saved and reloaded
      
      // info for printing out a message, by score, at end of game 
      int cval[CLSMAX+1];     // defining values for finish categories
      
      // some more widely-used stuff (dwarves, maybe other)
      int tk[20];
      int dseen[6];
      int dloc[6];
      int odloc[6];
      
      // misc variables
      int bonus;
      int clock1;
      int closed;
      int closng;
      int clsses;
      int dflag;
      int foo;
      int gaveup;
      int maxdie;
      int maxtrs;
      int mxscor;
      int numdie;
      int score, limit;
      int scorng;
      int turns;
      int tally, tally2;         // for scoring
      int chloc, chloc2;         // location of treasure chest
      int linuse, trvs;          // track sizes of some tables
      int tabndx, hntmax, abbnum;
      int verb, obj, knfloc;     // current items of interest 
      int verb_base, verb_class; // "verb" broken in two parts 
      BOOL panic;                // endgame flag
      int clock2;                // endgame timer
      int foobar;                // ??
      int dkill, daltlc;         // dwarf stuff
      int detail;                // controls long/short messages??
      BOOL lmwarn;               // darkness and/or lamp warning
      int iwest;                 // controls Witt's End warning
      // new variables added in the "structuring" process
      BOOL is_dead;              // just what it sounds like!
      int destination;           // need in several place
      BOOL wzdark;               // need in fns being put in adv_misc
      char wd1[STRL], wd2[STRL], wd1x[STRL], wd2x[STRL];   
      int spk;                   // persistent message number
      BOOL demo;                 // flag for short 30-move demo game 
      // some flow-control variables (flags)
      BOOL skip_user_input;
      BOOL skip_prelim_proc;
      
      // a whole bunch of "shortcut" variables - links to vocabulary words
      int       keys;
      int       lamp;
      int       grate;
      int       cage;
      int       rod;
      int       rod2;
      int       steps;
      int       bird;
      int       door;
      int       pillow;
      int       snake;
      int       fissur;
      int       tablet;
      int       clam;
      int       oyster;
      int       magzin;
      int       dwarf;
      int       knife;
      int       food;
      int       bottle;
      int       water;
      int       oil;
      int       plant;
      int       plant2;
      int       axe;
      int       mirror;
      int       dragon;
      int       chasm;
      int       troll;
      int       troll2;
      int       bear;
      int       messag;
      int       vend;
      int       batter;
      int       nugget;
      int       coins;
      int       chest;
      int       eggs;
      int       tridnt;
      int       vase;
      int       emrald;
      int       pyram;
      int       pearl;
      int       rug;
      int       chain;
      int       back;
      int       look;
      int       cave;
      int       null;
      int       entrnc;
      int       dprssn;
      int       say;
      int       lock;
      int       throw;
      int       find;
      int       invent;
      int       spices;
      int       enter;
      int       stream;
      int       walk;
                 };

extern struct game_data gm;      // put everything in here

#endif
