// STATEMENT FUNCTIONS
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "adv_util.h"
#include "adv_func.h"
//
//
// TOTING(OBJ)    = TRUE IF THE OBJ IS BEING CARRIED
// HERE(OBJ)      = TRUE IF THE OBJ IS AT "LOC" (OR IS BEING CARRIED)
// AT(OBJ)  = TRUE IF ON EITHER SIDE OF TWO-PLACED OBJECT
// LIQ(DUMMY)     = OBJECT NUMBER OF LIQUID IN BOTTLE
// LIQLOC(LOC)    = OBJECT NUMBER OF LIQUID (IF ANY) AT LOC
// BITSET(L,N)    = TRUE IF COND(L) HAS BIT N SET (BIT 0 IS UNITS BIT)
// FORCED(LOC)    = TRUE IF LOC MOVES WITHOUT ASKING FOR INPUT (COND=2)
// DARK(DUMMY)    = TRUE IF LOCATION "LOC" IS DARK
// PCT(N)       = TRUE N% OF THE TIME (N INTEGER FROM 0 TO 100)
// strpos(str,ch) = 1st index of ch in str (or -1) - easier than "strchr"
// strequ(str1,str2) = TRUE if equal, FALSE if not - compensate for strcmp's gm.backwards logic
//
// WZDARK SAYS WHETHER THE LOC HE"S LEAVING WAS DARK
// LMWARN SAYS WHETHER HE"S BEEN WARNED ABOUT LAMP GOING DIM
// CLOSNG SAYS WHETHER ITS CLOSING TIME YET
// PANIC SAYS WHETHER HE"S FOUND OUT HE"S TRAPPED IN THE CAVE
// CLOSED SAYS WHETHER WE"RE ALL THE WAY CLOSED
// GAVEUP SAYS WHETHER HE EXITED VIA "QUIT"
// SCORNG INDICATES TO THE SCORE ROUTINE WHETHER WE"RE DOING A "SCORE" COMMAND
// DEMO IS TRUE IF THIS IS A PRIME-TIME DEMONSTRATION GAME
// YEA IS RANDOM YES/NO REPLY

      

BOOL toting(int obj)
{
  return (
      gm.place[obj] == CARRIED
         );
}

BOOL here(int obj)
{
  return (
      gm.place[obj] == gm.loc || toting(obj)
         );
}

BOOL at(int obj)
{
  return (
      gm.place[obj] == gm.loc || gm.fixed[obj] == gm.loc
         );
}

int liq2(int pbotl)
{
  return (
      (1-pbotl)*gm.water+(pbotl/2)*(gm.water+gm.oil)
         );
}

int liq(void)   // returns?? probably oil or water or empty
{
  return (
      liq2( (gm.prop[gm.bottle]>-1-gm.prop[gm.bottle])
                 ? gm.prop[gm.bottle] 
                 : -1-gm.prop[gm.bottle] )
         );
}

int liqloc(int loc)
{
  return (
      liq2(((gm.cond[loc]/2*2%8)-5)*(gm.cond[loc]/4%2)+1)
         );
}

BOOL bitset(int l, int n)
{
  return (
      (gm.cond[l] & (1<<n)) != 0
         );
}

BOOL forced(int loc)
{
  return (
      gm.cond[loc] == 2
         );
}

BOOL dark(void)
{
  return (
        (gm.cond[gm.loc]%2) == 0 && (gm.prop[gm.lamp] == 0 || ! here(gm.lamp))
         );
}

int pct(int n)
{
  return (
      ran(100) < n
         );
}

int dwarf_here(int loc)
{
  int ix;
 
  for (ix=1;ix<=5;ix++)
    if (gm.dloc[ix] == loc)
      return (ix);          // works as TRUE, **AND** identifies which dwarf
  return (0);               // works as FALSE
}

int strpos(char *str, char ch)
{
  int ix, found = -1;

  for (ix=0;ix<strlen(str) && -1 == found;ix++)
    if (ch == str[ix]) found = ix;
  return (found);
}

BOOL strequ(char *str1, char *str2)
{
  return (strcmp(str1,str2) == 0);
}
