// adv_io.c
// I/O ROUTINES (SPEAK, PSPEAK, RSPEAK, GETIN, YES, A5TOA1)
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "adv_io.h"

// PRINT THE MESSAGE WHICH STARTS AT LINES(N).  PRECEDE IT WITH A BLANK LINE
// UNLESS BLKLIN IS FALSE.
// new - print the gm.message pointed to by "lyne"
void speak(char *lyne)
{
  if ( (lyne != NULL) &&               // something there
       (strncmp(lyne,">$<",3)) )       // and not special do-not-print chars
    printf("%s\n",lyne);               // print line(s), LF
}


// FIND THE SKIP+1ST MESSAGE FROM MSG AND PRINT IT.  MSG SHOULD BE THE INDEX OF
// THE INVENTORY MESSAGE FOR OBJECT.  (INVEN+N+1 MESSAGE IS PROP=N MESSAGE).
// new gm.setup - "gm.inventory" message is in gm.ptext[msg], 
//             "gm.prop == n" message is in gm.ptexta[msg][n]
// ignore original stuff
void pspeak(int msg, int skip)
{
      char *msg_to_speak;

      if(skip < 0)
          msg_to_speak = gm.ptext[msg];    // skip == -1, use "gm.inventory" message
      else
          msg_to_speak = gm.ptexta[msg][skip];   // skip >= 0, use alt message
      speak(msg_to_speak);
}

// PRINT THE I-TH "RANDOM" MESSAGE (SECTION 6 OF DATABASE).
void rspeak(int i)
{
  if (i != 0)
    speak(gm.rtext[i]);
}

// PRINT THE I-TH "MAGIC" MESSAGE (SECTION 12 OF DATABASE).
void mspeak(int i)
{
  if ( i!=0 )
    speak(gm.mtext[i]);
}

// GET A COMMAND FROM THE ADVENTURER.  SNARF OUT THE FIRST WORD, PAD IT WITH
// BLANKS, AND RETURN IT IN WORD1.  CHARS 6 THRU 10 ARE RETURNED IN WORD1X, IN
// CASE WE NEED TO PRINT OUT THE WHOLE WORD IN AN ERROR MESSAGE.  ANY NUMBER OF
// BLANKS MAY FOLLOW THE WORD.  IF A SECOND WORD APPEARS, IT IS RETURNED IN
// WORD2 (CHARS 6 THRU 10 IN WORD2X), ELSE WORD2 IS SET TO ZERO.
// well, except that standard zero-terminated C-style strings are being
//   used instead of blank-padded 5-char strings
#define ONEWD 127
#define TWOWDS 255
void getin(char *word1, char *word1x, char *word2, char *word2x)
{
  char str1[TWOWDS], inwd1[ONEWD], inwd2[ONEWD], ch;   
  int ix, iy;  

      // we really need a prompt (where did the original get lost???)
      // printf("?> ");      // **NO** newline here
      // then again, maybe the caller should do this?

      ix = -1;
      do
      { 
        str1[++ix] = ch = getchar();
      }
      while ( (ix < TWOWDS-1) && (ch != '\n') ); 
      if (str1[ix] != '\n')
        do
        {
          ch = getchar();
        }
        while (ch != '\n');
      str1[ix] = '\0'; 
      for (ix=0;ix<strlen(str1);ix++)
        str1[ix] = toupper(str1[ix]);
      
      // debugging
      // printf("Unparsed input: **%s**\n",str1);

      inwd1[0] = inwd2[0] = '\0';
      ix = iy = 0;
      while (str1[ix] == ' ') ix++;   // discard any leading blanks
      while (str1[ix] != ' ' && str1[ix] != '\0')
        inwd1[iy++] = str1[ix++];     // copy valid chars to word 1
      inwd1[iy] = '\0';               // make sure word 1 is terminated
      if (str1[ix] != '\0')           // if there is more, ...
      {
        iy = 0;                       // start over for word 2
        while (str1[ix] == ' ') ix++; // discard any leading blanks
        while (str1[ix] != ' ' && str1[ix] != '\0')
          inwd2[iy++] = str1[ix++];   // copy valid chars to word 2
        inwd2[iy] = '\0';             // make sure word 2 is terminated
      }

      // debugging
      // printf("Intermediate input: ==%s== ==%s==\n",inwd1,inwd2);

      // the next lines may generate and assign gm.null substrings - this is OK
      word1[0] = word1x[0] = word2[0] = word2x[0] = '\0';  // first, clear output    
      strncpy(word1,inwd1,5);     // at most 5 chars
      word1[5] = '\0';          // be ABSOLUTELY CERTAIN it is terminated 
      if (strlen(inwd1) > 5)
      { 
        strncpy(word1x,inwd1+5,5);  // this one is likely gm.null
        word1x[5] = '\0';          // be ABSOLUTELY CERTAIN it is terminated
      }
      strncpy(word2,inwd2,5);     // same here
      word2[5] = '\0';          // be ABSOLUTELY CERTAIN it is terminated
      if (strlen(inwd2) > 5)
      { 
        strncpy(word2x,inwd2+5,5);
        word2x[5] = '\0';          // be ABSOLUTELY CERTAIN it is terminated
      }
      //debug
      // printf("Final input is >>%s<< >>%s<< >>%s<< >>%s<<\n",word1,word1x,word2,word2x);
}

// CALL YESX (BELOW) WITH MESSAGES FROM SECTION 6.
BOOL yes(int x, int y, int z)
{
  return (yesx(x,y,z,rspeak));
}

// CALL YESX (BELOW) WITH MESSAGES FROM SECTION 12.
BOOL yesm(int x, int y, int z)
{
  return (yesx(x,y,z,mspeak));
}

// PRINT MESSAGE X, WAIT FOR YES/NO ANSWER.  IF YES, PRINT Y AND LEAVE YEA
// TRUE; IF NO, PRINT Z AND LEAVE YEA FALSE.  SPK IS EITHER RSPEAK OR MSPEAK.
BOOL yesx(int x, int y, int z, void spk(int))
{
  int retval;
  BOOL answered = FALSE;
  char reply[5],junk1[5],junk2[5],junk3[5];

  while (!answered)
  {
    if (x!=0) 
      spk(x);
    printf(PROMPT);
    getin(reply,junk1,junk2,junk3);
    if ( (strcmp(reply,"YES") == 0) ||
         (strcmp(reply,"Y") == 0) )
    {
      retval = TRUE;
      answered = TRUE;
      if (y != 0) spk(y);
    }
    else if ( (strcmp(reply,"NO") == 0) ||
              (strcmp(reply,"N") == 0) )
    {
      retval = FALSE;
      answered = TRUE;
      if (z != 0) spk(z);
    }
    else
      printf(" please answer the question.\n");
  }
  return retval;
}


/*  with a little bit of luck, we don't need this any more!
      subroutine a5toa1(a,b,c,chars,leng);

// A AND B CONTAIN A 1- TO 9-CHARACTER WORD IN A5 FORMAT, C CONTAINS ANOTHER
// WORD AND/OR PUNCTUATION.  THEY ARE UNPACKED TO ONE CHARACTER PER WORD IN THE
// ARRAY "CHARS", WITH EXACTLY ONE BLANK BETWEEN B AND C (OR NONE, IF C >= 0).
// THE INDEX OF THE LAST NON-BLANK CHAR IN CHARS IS RETURNED IN LENG.

      implicit integer(a-z);
      dimension chars(20),words(3);
      data mask,blank/"774000000000," "/;

      words(1)=a;
      words(2)=b;
      words(3)=c;
      posn=1;
      do 1 word=1,3;
      if(word == 2 && posn!=6)goto 1;
      if(word == 3 && c < 0)posn=posn+1;
      do 2 ch=1,5;
      chars(posn)=(words(word) && mask)+(blank-(blank && mask));
      if(chars(posn) == blank)goto 1;
      leng=posn;
      words(word)=shift(words(word),7);
2     posn=posn+1;
1     continue;
      return;
      end;
*/
