// FINISH CONSTRUCTING INTERNAL DATA FORMAT

#include "adv_setup.h"
 
void finish_setup(void)
{
  // HAVING READ IN THE DATABASE, CERTAIN THINGS ARE NOW CONSTRUCTED.  PROPS ARE
  // SET TO ZERO.  WE FINISH SETTING UP COND BY CHECKING FOR FORCED-MOTION TRAVEL
  // ENTRIES.  THE PLAC AND FIXD ARRAYS ARE USED TO SET UP ATLOC(N) AS THE FIRST
  // OBJECT AT LOCATION N, AND LINK(OBJ) AS THE NEXT OBJECT AT THE SAME LOCATION
  // AS OBJ.  (OBJ>100 INDICATES THAT FIXED(OBJ-100) = LOC; LINK(OBJ) IS STILL THE
  // CORRECT LINK TO USE.)  ABB IS ZEROED; IT CONTROLS WHETHER THE ABBREVIATED
  // DESCRIPTION IS PRINTED.  COUNTS MOD 5 UNLESS "LOOK" IS USED.
  int i, k, kk;                // loops, etc.
  int rtused, magused;         // for printout of space used
  BOOL ltextZ;

    for (i = 1;i<=OBJSIZ;i++)
    {
      gm.place[i] = 0;
      gm.prop[i] = 0;
      gm.link[i] = 0;
      gm.link[i+100] = 0;
    }

    for (i = 1;i<=LOCSIZ;i++)
    {
      gm.abb[i] = 0;
      if (gm.ltext[i] !=  0 && gm.key[i]  !=  0)
      {
        k = gm.key[i];
        if (gm.travwd[k] ==  1)    // used to be gm.travel[k]%1000
          gm.cond[i] = 2;
        gm.atloc[i] = 0;
      } 
    }

  // SET UP THE ATLOC AND LINK ARRAYS AS DESCRIBED ABOVE.  WE"LL USE THE DROP
  // SUBROUTINE, WHICH PREFACES NEW OBJECTS ON THE LISTS.  SINCE WE WANT THINGS
  // IN THE OTHER ORDER, WE"LL RUN THE LOOP BACKWARDS.  IF THE OBJECT IS IN TWO
  // LOCS, WE DROP IT TWICE.  THIS ALSO SETS UP "PLACE" AND "FIXED" AS COPIES OF
  // "PLAC" AND "FIXD".  ALSO, SINCE TWO-PLACED OBJECTS ARE TYPICALLY BEST
  // DESCRIBED LAST, WE"LL DROP THEM FIRST.

      for (k = 100;k>=1;k--)
      {
        if (gm.fixd[k] >  0)
        {
          drop(k+100,gm.fixd[k]);
          drop(k,gm.plac[k]);
        }  
      }

      for (k = 100;k>=1;k--)
      {
        gm.fixed[k] = gm.fixd[k];
        if (gm.plac[k] != 0 && gm.fixd[k] <=  0)
          drop(k,gm.plac[k]);
      }

  // TREASURES, AS NOTED EARLIER, ARE OBJECTS 50 THROUGH MAXTRS (CURRENTLY 79).
  // THEIR PROPS ARE INITIALLY -1, AND ARE SET TO 0 THE FIRST TIME THEY ARE
  // DESCRIBED.  TALLY KEEPS TRACK OF HOW MANY ARE NOT YET FOUND, SO WE KNOW
  // WHEN TO CLOSE THE CAVE.  TALLY2 COUNTS HOW MANY CAN NEVER BE FOUND (E.G. IF
  // LOST BIRD OR BRIDGE).

      gm.maxtrs = 79;
      gm.tally = 0;
      gm.tally2 = 0;
      for (i = 50;i<=gm.maxtrs;i++)
      { 
        if (gm.ptext[i] != 0)
          gm.prop[i] = -1;
        gm.tally = gm.tally - gm.prop[i];
      }

  // CLEAR THE HINT STUFF.  HINTLC(I) IS HOW LONG HE"S BEEN AT LOC WITH COND BIT
  // I.  HINTED(I) IS TRUE IFF HINT I HAS BEEN USED.

      for (i = 1;i<=gm.hntmax;i++)
      {  
        gm.hinted[i] =  FALSE;
        gm.hintlc[i] = 0;
      }

  // DEFINE SOME HANDY MNEMONICS.  THESE CORRESPOND TO OBJECT NUMBERS.
  //   original vocab did the mod 1000 if 2nd arg was not -1
  //   this caused problems elsewhere, so we dropped it

      gm.keys = vocab("KEYS",1)%1000;
      gm.lamp = vocab("LAMP",1)%1000;
      gm.grate = vocab("GRATE",1)%1000;
      gm.cage = vocab("CAGE",1)%1000;
      gm.rod = vocab("ROD",1)%1000;
      gm.rod2 = gm.rod+1;
      gm.steps = vocab("STEPS",1)%1000;
      gm.bird = vocab("BIRD",1)%1000;
      gm.door = vocab("DOOR",1)%1000;
      gm.pillow = vocab("PILLO",1)%1000;
      gm.snake = vocab("SNAKE",1)%1000;
      gm.fissur = vocab("FISSU",1)%1000;
      gm.tablet = vocab("TABLE",1)%1000;
      gm.clam = vocab("CLAM",1)%1000;
      gm.oyster = vocab("OYSTE",1)%1000;
      gm.magzin = vocab("MAGAZ",1)%1000;
      gm.dwarf = vocab("DWARF",1)%1000;
      gm.knife = vocab("KNIFE",1)%1000;
      gm.food = vocab("FOOD",1)%1000;
      gm.bottle = vocab("BOTTL",1)%1000;
      gm.water = vocab("WATER",1)%1000;
      gm.oil = vocab("OIL",1)%1000;
      gm.plant = vocab("PLANT",1)%1000;
      gm.plant2 = gm.plant+1;
      gm.axe = vocab("AXE",1)%1000;
      gm.mirror = vocab("MIRRO",1)%1000;
      gm.dragon = vocab("DRAGO",1)%1000;
      gm.chasm = vocab("CHASM",1)%1000;
      gm.troll = vocab("TROLL",1)%1000;
      gm.troll2 = gm.troll+1;
      gm.bear = vocab("BEAR",1)%1000;
      gm.messag = vocab("MESSA",1)%1000;
      gm.vend = vocab("VENDI",1)%1000;
      gm.batter = vocab("BATTE",1)%1000;

  // OBJECTS FROM 50 THROUGH WHATEVER ARE TREASURES.  HERE ARE A FEW.

      gm.nugget = vocab("GOLD",1)%1000;
      gm.coins = vocab("COINS",1)%1000;
      gm.chest = vocab("CHEST",1)%1000;
      gm.eggs = vocab("EGGS",1)%1000;
      gm.tridnt = vocab("TRIDE",1)%1000;
      gm.vase = vocab("VASE",1)%1000;
      gm.emrald = vocab("EMERA",1)%1000;
      gm.pyram = vocab("PYRAM",1)%1000;
      gm.pearl = vocab("PEARL",1)%1000;
      gm.rug = vocab("RUG",1)%1000;
      gm.chain = vocab("CHAIN",1)%1000;

  // THESE ARE MOTION-VERB NUMBERS.

      gm.back = vocab("BACK",0)%1000;
      gm.look = vocab("LOOK",0)%1000;
      gm.cave = vocab("CAVE",0)%1000;
      gm.null = vocab("NULL",0)%1000;
      gm.entrnc = vocab("ENTRA",0)%1000;
      gm.dprssn = vocab("DEPRE",0)%1000;
      gm.enter = vocab("ENTER",0)%1000;
      gm.stream = vocab("STREA",0)%1000;

  // AND SOME ACTION VERBS.

      gm.say = vocab("SAY",2)%1000;
      gm.lock = vocab("LOCK",2)%1000;
      gm.throw = vocab("THROW",2)%1000;
      gm.find = vocab("FIND",2)%1000;
      gm.invent = vocab("INVEN",2)%1000;
      gm.walk = vocab("WALK",2)%1000;     // go, gm.travel, etc.

  // INITIALISE THE DWARVES.  DLOC IS LOC OF DWARVES, HARD-WIRED IN.  ODLOC IS
  // PRIOR LOC OF EACH DWARF, INITIALLY GARBAGE.  DALTLC IS ALTERNATE INITIAL LOC
  // FOR DWARF, IN CASE ONE OF THEM STARTS OUT ON TOP OF THE ADVENTURER.  (NO 2
  // OF THE 5 INITIAL LOCS ARE ADJACENT.)  DSEEN IS TRUE IF DWARF HAS SEEN HIM.
  // DFLAG CONTROLS THE LEVEL OF ACTIVATION OF ALL THIS:
  //    0     NO DWARF STUFF YET (WAIT UNTIL REACHES HALL OF MISTS)
  //    1     REACHED HALL OF MISTS, BUT HASN"T MET FIRST DWARF
  //    2     MET FIRST DWARF, OTHERS START MOVING, NO KNIVES THROWN YET
  //    3     A KNIFE HAS BEEN THROWN (FIRST SET ALWAYS MISSES)
  //    3+    DWARVES ARE MAD (INCREASES THEIR ACCURACY)
  // SIXTH DWARF IS SPECIAL (THE PIRATE).  HE ALWAYS STARTS AT HIS CHEST"S
  // EVENTUAL LOCATION INSIDE THE MAZE.  THIS LOC IS SAVED IN CHLOC FOR REF.
  // THE DEAD END IN THE OTHER MAZE HAS ITS LOC STORED IN CHLOC2.

      gm.chloc = 114;
      gm.chloc2 = 140;
      for (i = 1;i<=6;i++)
        gm.dseen[i] =  FALSE;
      gm.dflag = 0;
      gm.dloc[1] = 19;
      gm.dloc[2] = 27;
      gm.dloc[3] = 33;
      gm.dloc[4] = 44;
      gm.dloc[5] = 64;
      gm.dloc[6] = gm.chloc;
      gm.daltlc = 18;

  // OTHER RANDOM FLAGS AND COUNTERS, AS FOLLOWS:
  //    TURNS TALLIES HOW MANY COMMANDS HE"S GIVEN (IGNORES YES/NO)
  //    LIMIT LIFETIME OF LAMP (NOT SET HERE)
  //    IWEST HOW MANY TIMES HE"S SAID "WEST" INSTEAD OF "W"
  //    KNFLOC      0 IF NO KNIFE HERE, LOC IF KNIFE HERE, -1 AFTER CAVEAT
  //    DETAIL      HOW OFTEN WE"VE SAID "NOT ALLOWED TO GIVE MORE DETAIL"
  //    ABBNUM      HOW OFTEN WE SHOULD PRINT NON-ABBREVIATED DESCRIPTIONS
  //    MAXDIE      NUMBER OF REINCARNATION MESSAGES AVAILABLE (UP TO 5)
  //    NUMDIE      NUMBER OF TIMES KILLED SO FAR
  //    HOLDNG      NUMBER OF OBJECTS BEING CARRIED
  //    DKILL NUMBER OF DWARVES KILLED (UNUSED IN SCORING, NEEDED FOR MSG)
  //    FOOBAR      CURRENT PROGRESS IN SAYING "FEE FIE FOE FOO".
  //    BONUS USED TO DETERMINE AMOUNT OF BONUS IF HE REACHES CLOSING
  //    CLOCK1      NUMBER OF TURNS FROM FINDING LAST TREASURE TILL CLOSING
  //    CLOCK2      NUMBER OF TURNS FROM FIRST WARNING TILL BLINDING FLASH
  //    BOOLS WERE EXPLAINED EARLIER

      gm.turns = 0;
      gm.lmwarn =  FALSE;
      gm.iwest = 0;
      gm.knfloc = 0;
      gm.detail = 0;
      gm.abbnum = 5;
      for (i = 0;i<=4;i++)
        if (gm.rtext[2*i+81] != 0)
          gm.maxdie = i+1;
      gm.numdie = 0;
      gm.holdng = 0;
      gm.dkill = 0;
      gm.foobar = 0;
      gm.bonus = 0;
      gm.clock1 = 30;
      gm.clock2 = 50;
      gm.saved = -1;
      gm.closng =  FALSE;
      gm.panic =  FALSE;
      gm.closed =  FALSE;
      gm.gaveup =  FALSE;
      gm.scorng =  FALSE;
      gm.described_loc = -1;    // assure description first time 

  // IF SETUP = 1, REPORT ON AMOUNT OF ARRAYS ACTUALLY USED, TO PERMIT REDUCTIONS.
    if (gm.setup == 1) 
    {
      gm.setup = 2;

      for (kk=LOCSIZ,ltextZ=TRUE;kk>=1;kk--)
      {
        if (gm.ltext[kk] != 0)
          {
            ltextZ = FALSE;
            break;
          }
      }

      if (ltextZ) gm.obj = 0;

      for (k = 1;k<=100;k++)
        if (gm.ptext[k] != 0)
          gm.obj = gm.obj+1;

      for (k = 1;k<=gm.tabndx;k++)
        if (gm.ktab[k]/1000  ==  2)
          gm.verb = gm.ktab[k]-2000;

      for (rtused = RTXSIZ;rtused>=1;rtused--)
        if (gm.rtext[rtused] != 0) break;

      for (magused=MAGSIZ;magused>=1;magused--)
        if (gm.mtext[magused] != 0) break;

      k = 100;
      // printf("table space used:\n");
      // printf(" %6i of %6i bytes of messages\n",gm.nblock-gm.bblock,LINSIZ*5);
      // printf(" %6i of %6i travel options\n",gm.trvs,TRVSIZ);
      // printf(" %6i of %6i vocabulary words\n",gm.tabndx,TABSIZ);
      // printf(" %6i of %6i locations\n",kk,LOCSIZ);
      // printf(" %6i of %6i objects\n",gm.obj,OBJSIZ);
      // printf(" %6i of %6i action verbs\n",gm.verb,VRBSIZ);
      // printf(" %6i of %6i rtext messages\n",rtused,RTXSIZ);
      // printf(" %6i of %6i class messages\n",gm.clsses,CLSMAX);
      // printf(" %6i of %6i hints\n",gm.hntmax,HNTSIZ);
      // printf(" %6i of %6i magic messages\n",magused,MAGSIZ);

      // FINALLY, SINCE WE"RE CLEARLY SETTING THINGS UP FOR THE FIRST TIME...
      poof();
  
    }
}  // end finish_setup ---------------------------------------------------
