// adventur.h
// global definitions for adventure game

#ifndef ADVENTUR_H
#define ADVENTUR_H

typedef unsigned char BOOL;    // Fortran "logical"
#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif

#define FOREVER 1     // more mnemonic for loops

typedef struct date_time {int d;     // date
                          int t;     // time
                         } DATM, *DATMP;

#define SEVENYRS  (7*365+2)   // days from 1-1-70 to 1-1-77 (incl 2 leap days)
#define TZ_OFFSET -4          // time zone offset from GMT ; -4 is EDT, -5 is EST 

// file name for database file - make it variable later???
#define DATFYL  "advent.dat"

// string length - 6, to hold 5 chars like the PDP Fortran originally used
#define STRL 6

// standard prompt for user input
#define PROMPT "?> "

// CURRENT LIMITS:
//     9650 WORDS OF MESSAGE TEXT (LINES, LINSIZ).
#define LINSIZ 9650
//    750 TRAVEL OPTIONS (TRAVEL, TRVSIZ).
#define TRVSIZ 750
//    300 VOCABULARY WORDS (KTAB, ATAB, TABSIZ).
#define TABSIZ 300
//    150 LOCATIONS (LTEXT, STEXT, KEY, COND, ABB, ATLOC, LOCSIZ).
#define LOCSIZ 150
#define CARRIED -1   // being carried is a special location
#define NOWHERE 0    // non-existent loc - used to destroy object
//    100 OBJECTS (PLAC, PLACE, FIXD, FIXED, LINK (TWICE), PTEXT, PROP).
#define OBJSIZ 100
#define OBJALTMAX 8  // max alternate obj descriptions
//     35 "ACTION" VERBS (ACTSPK, VRBSIZ).
#define VRBSIZ 35
//    205 RANDOM MESSAGES (RTEXT, RTXSIZ).
#define RTXSIZ 205
//     12 DIFFERENT PLAYER CLASSIFICATIONS (CTEXT, CVAL, CLSMAX).
#define CLSMAX 12
//     20 HINTS, LESS 3 (HINTLC, HINTED, HINTS, HNTSIZ).
#define HNTSIZ 20
//     35 MAGIC MESSAGES (MTEXT, MAGSIZ).
#define MAGSIZ 35

#endif
